package com.agilex.healthcare.directscheduling.domain;


import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "bookedAppointment", namespace = Namespace.DirectScheduling)
@XmlType(namespace = Namespace.DirectScheduling)
public class BookedAppointment extends DomainTransferObject {

    private static final long serialVersionUID = -1795283999708413958L;

    @XmlElement
    private String appointmentLength;
    @XmlElement
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date appointmentTime;
    @XmlElement
    private String status;
    @XmlElement
    private SchedulingClinic clinic;
    @XmlElement
    private String patientId;
    @XmlElement
    private String purpose;
    @XmlElement
    private String type;
    @XmlElement
    private String currentStatus;
    @XmlElement
    private String bookingNote;
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date labDateTime;
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date ekgDateTime;
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date xrayDateTime;

    public String getAppointmentLength() {
        return appointmentLength;
    }

    public void setAppointmentLength(String appointmentLength) {
        this.appointmentLength = appointmentLength;
    }

    public Date getAppointmentTime() {
        return appointmentTime;
    }

    public void setAppointmentTime(Date appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public SchedulingClinic getClinic() {
        return clinic;
    }

    public void setClinic(SchedulingClinic clinic) {
        this.clinic = clinic;
    }

    public String getPatientId() {
        return patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCurrentStatus() {
        return currentStatus;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    public String getBookingNote() {
        return bookingNote;
    }

    public void setBookingNote(String bookingNote) {
        this.bookingNote = bookingNote;
    }

    public Date getLabDateTime() {
        return labDateTime;
    }

    public void setLabDateTime(Date labDateTime) {
        this.labDateTime = labDateTime;
    }

    public Date getEkgDateTime() {
        return ekgDateTime;
    }

    public void setEkgDateTime(Date ekgDateTime) {
        this.ekgDateTime = ekgDateTime;
    }

    public Date getXrayDateTime() {
        return xrayDateTime;
    }

    public void setXrayDateTime(Date xrayDateTime) {
        this.xrayDateTime = xrayDateTime;
    }

}
